<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <!-- REQUIRED META TAGS -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- FONTS -->
    <link rel="stylesheet" href="<?php echo e(asset('themes/default/fonts/fontawesome/fontawesome.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('themes/default/fonts/typography/public/public.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('themes/default/fonts/typography/rubik/rubik.css')); ?>">

    <!-- CUSTOM STYLE -->
    <link rel="stylesheet" href="<?php echo e(asset('themes/default/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('themes/default/css/custom.css')); ?>">

    <title><?php if(trim($__env->yieldContent('template_title'))): ?><?php echo $__env->yieldContent('template_title'); ?>
        | <?php endif; ?> <?php echo e(trans('installer.title')); ?></title>
    <script>
        window.Laravel = <?php echo json_encode([
            'csrfToken' => csrf_token(),
        ]); ?>
    </script>
</head>
<body class="bg-installer bg-no-repeat bg-cover bg-center">
<div id="step-group" class="w-screen h-screen  overflow-y-auto p-3 sm:p-10">
    <div id="steps" class="block w-[550px] mx-auto overflow-hidden rounded-xl shadow-paper p-8 bg-white">
        <h3 class="text-lg font-semibold capitalize text-center mb-7"><?php echo $__env->yieldContent('title'); ?></h3>
        <?php echo $__env->yieldContent('container'); ?>
    </div>
</div>

<script src="<?php echo e(asset('themes/default/js/jquery-v3.2.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('themes/default/js/jqueryScript.js')); ?>"></script>
<script src="<?php echo e(asset('themes/default/js/installer.js')); ?>"></script>
</body>
</html>
<?php /**PATH /data01/virt124792/domeenid/www.hungryhub.fi/htdocs/resources/views/installer/layouts/master.blade.php ENDPATH**/ ?>